import json

from absl import flags
from absl import logging
from tf_agents.environments import tf_py_environment
from tf_agents.environments import wrappers


FLAGS = flags.FLAGS


def make_hparam_string(xm_parameters, **hparam_str_dict):
  if xm_parameters:
    for key, value in json.loads(xm_parameters).items():
      if key not in hparam_str_dict:
        hparam_str_dict[key] = value
  return ','.join([
      '%s=%s' % (k, str(hparam_str_dict[k]))
      for k in sorted(hparam_str_dict.keys())
  ])
