#!/bin/bash
for horizon in 96 192
  do
    python3 -m train \
    --transform=true \
    --layer_norm=true \
    --holiday=true \
    --dropout_rate=0.5 \
    --batch_size=512 \
    --hidden_size=512 \
    --num_layers=2 \
    --hist_len=720 \
    --pred_len=$horizon \
    --dataset=etth1 \
    --decoder_output_dim=32 \
    --final_decoder_hidden=16 \
    --num_split=1 \
    --learning_rate=0.000984894211777642 \
    --min_num_epochs=20
  done
for horizon in 336 720
  do
    python3 -m train \
    --transform=true \
    --layer_norm=true \
    --holiday=true \
    --dropout_rate=0.3 \
    --batch_size=512 \
    --hidden_size=256 \
    --num_layers=2 \
    --hist_len=720 \
    --pred_len=$horizon \
    --dataset=etth1 \
    --decoder_output_dim=8 \
    --final_decoder_hidden=128 \
    --num_split=1 \
    --learning_rate=0.00003822279848104051 \
    --min_num_epochs=20 \
    --hist_len=336
  done