info.obs.y <- function(y, x, dose_history, pars){
  pb <- tox_model_par(x, dose_history, pars)
  
  deta <- y-pb$pb
  db0 <- pb$xMat
  db1 <- pb$xMat*dose_history 
  db <- cbind(as.vector(deta)*db0, as.vector(deta)*db1)
  
  n <- nrow(db)
  mt <- sapply(1:n, function(i){
    db[i,]%*%t(db[i,])
  })
  p <- ncol(db)
  mt <- matrix(apply(mt, 1, sum), nrow = p)
  
  return(mt)
}

info.exp.y <- function(x, dose_history, pars){
  pb <- tox_model_par(x, dose_history, pars)
  
  db0 <- pb$xMat
  db1 <- pb$xMat*dose_history 
  db <- cbind(db0, db1)
  
  n <- nrow(db)
  mt <- sapply(1:n, function(i){
    db[i,]%*%t(db[i,])*pb$pb[i]*(1-pb$pb[i])
  })
  p <- ncol(db)
  mt <- matrix(apply(mt, 1, sum), nrow = p)
  
  return(mt)
}

info.obs.z <- function(z, x, dose_history, pars){
  pb <- eff_model_par(x, dose_history, pars)
  
  deta <- z-pb$pb
  dc0 <- pb$xMat
  dc1 <- pb$xMat*dose_history 
  dc2 <- pb$xMat*dose_history^2
  dc <- cbind(as.vector(deta)*dc0, as.vector(deta)*dc1, as.vector(deta)*dc2)
  
  n <- nrow(dc)
  mt <- sapply(1:n, function(i){
    dc[i,]%*%t(dc[i,])
  })
  p <- ncol(dc)
  mt <- matrix(apply(mt, 1, sum), nrow = p)
  
  return(mt)
} 

info.exp.z <- function(x, dose_history, pars){
  pb <- eff_model_par(x, dose_history, pars)
  
  dc0 <- pb$xMat
  dc1 <- pb$xMat*dose_history 
  dc2 <- pb$xMat*dose_history^2
  dc <- cbind(dc0, dc1, dc2)
  
  n <- nrow(dc)
  mt <- sapply(1:n, function(i){
    dc[i,]%*%t(dc[i,])*pb$pb[i]*(1-pb$pb[i])
  })
  p <- ncol(dc)
  mt <- matrix(apply(mt, 1, sum), nrow = p)
  
  return(mt)
} 

info.obs.yz <- function(y, z, x, tox_history, dose_history, pars){
  beta <- pars[1:4]
  gamma <- pars[5:10]
  pb.y <- tox_model_par(x, tox_history, beta)
  pb.z <- eff_model_par(x, dose_history, gamma)
  
  deta <- y-pb.y$pb
  db0 <- pb.y$xMat
  db1 <- pb.y$xMat*tox_history 
  db <- cbind(as.vector(deta)*db0, as.vector(deta)*db1)
  
  deta <- z-pb.z$pb
  dc0 <- pb.z$xMat
  dc1 <- pb.z$xMat*dose_history 
  dc2 <- pb.z$xMat*dose_history^2
  dc <- cbind(as.vector(deta)*dc0, as.vector(deta)*dc1, as.vector(deta)*dc2)
  
  dbc <- cbind(db, dc)
  
  n <- nrow(dbc)
  mt <- sapply(1:n, function(i){
    dbc[i,]%*%t(dbc[i,])
  })
  p <- ncol(dbc)
  mt <- matrix(apply(mt, 1, sum), nrow = p)
  
  return(mt)
}

info.exp.yz <- function(x, tox_history, dose_history, pars){
  beta <- pars[1:4]
  gamma <- pars[5:10]
  
  mt1 <- info.exp.y(x, tox_history, beta)
  mt2 <- info.exp.z(x, dose_history, gamma)
  
  mt <- Matrix::bdiag(list(mt1, mt2))
  
  return(mt)
}

eval.info <- function(y, z,  x, tox_history, dose_history, pars, eff_tox, eff_dose, x.new, level.new, type = c("tox", "eff", "joint")){
  if(type == "tox"){
    obs.info <- info.obs.y(y, x, tox_history, pars)
    new.info <- info.exp.y(x.new, eff_tox[level.new], pars)
  }else if(type == "eff"){
    obs.info <- info.obs.z(y, x, dose_history, pars)
    new.info <- info.exp.z(x.new, eff_dose[level.new], pars)
  }else{
    obs.info <- info.obs.yz(y, z, x, tox_history, dose_history, pars)
    new.info <- info.exp.yz(x.new, eff_tox[level.new], eff_dose[level.new], pars)
  }
  info <- obs.info + new.info
  e <- eigen(info)
  return(-1*sum(log(e$values)))
}
