from __future__ import annotations

from loguru import logger

from tabicl.config.config_benchmark_sweep import ConfigBenchmarkSweep
from tabicl.core.enums import SearchType
from tabicl.results.dataset_plot import make_dataset_plots
from tabicl.results.default_results import make_default_results
from tabicl.results.hyperparam_plots import make_hyperparam_plots
from tabicl.results.results_sweep import ResultsSweep
from tabicl.sweeps.make_plots_utils import default_results_not_yet_made, sweep_default_finished
from tabicl.utils.debugger import debugger_is_active


def plot_results_whytrees(cfg: ConfigBenchmarkSweep, results_sweep: ResultsSweep) -> None:

    if sweep_default_finished(cfg, results_sweep) and (default_results_not_yet_made(cfg) or debugger_is_active()):
        logger.info(f"Start making default results for model {cfg.model_name.value} on benchmark {cfg.benchmark.name}")
        make_default_results(cfg, results_sweep)
        logger.info(f"Finished making default results for model {cfg.model_name.value} on benchmark {cfg.benchmark.name}")


    if cfg.search_type == SearchType.RANDOM:
        logger.info(f"Start making hyperparam plots for {cfg.search_type.value} search for {cfg.model_name.value} on {cfg.benchmark.name}")
        make_hyperparam_plots(cfg, results_sweep)
        logger.info(f"Finished making hyperparam plots for {cfg.search_type.value} search for {cfg.model_name.value} on {cfg.benchmark.name}")
    
    
    if sweep_default_finished(cfg, results_sweep):
        logger.info(f"Start making dataset plots for {cfg.search_type.value} search for {cfg.model_name.value} on {cfg.benchmark.name}")
        make_dataset_plots(cfg, results_sweep)
        logger.info(f"Finished making dataset plots for {cfg.search_type.value} search for {cfg.model_name.value} on {cfg.benchmark.name}")

