K = 3
k = 3
l = 2
A1 = A[[k]]
A2 = A[[l]]
z1hat = spec_clust(A[[k]], K)
z2hat = spec_clust(A[[l]], K)
B1hat = estim_dcsbm(A[[k]], z1hat)$B
B2hat = estim_dcsbm(A[[l]], z2hat)$B


Pt = matching(B1hat, B2hat, z1hat, z2hat)
zmap <- mat2perm(Pt)

S1 = block_sums_gpt4(A1, zmap[z1hat])
S2 = block_sums_gpt4(A2, z2hat)

ns1 <- as.vector(table(zmap[z1hat]))
ns2 <- as.vector(table(z2hat))

m1 <- pmax(ns1%*% t(ns1) - diag((ns1^2 + ns1)/2), 1)
m2 <- pmax(ns2%*% t(ns2) - diag((ns2^2 + ns2)/2), 1)

Bhat = (S1 + S2)/(m1 + m2)
Sigma_hat = Bhat*(1- Bhat)
That = 0
for (i in 1:K){
  for (j in i:K){
    # mbar half of the harmonic mean.
    mbar = m1[i,j] * m2[i,j]/(m1[i,j] + m2[i,j])
    addd = (mbar/Sigma_hat[i,j])*((S1[i,j]/m1[i,j]) - (S2[i,j]/m2[i,j]))^2
    That = That + addd
    # addd is chi squared with 1 df
    print(i)
    print(j)
    print(addd)
  }
}
return(That)














NMC = 1000
That_array = rep(0,NMC)
err1_array = rep(0,NMC)
err2_array = rep(0,NMC)
set.seed(100)
start_time <- Sys.time()
for(iter in 1:NMC){
  if(iter%% 100==0)
    print(iter)
  
  
  K = 2
  n = 1000
  B = matrix(runif(K*K, 0.2, 0.7), nrow = K)
  B = (B + t(B))/2
  
  z1 = sample(1:K, n, replace = TRUE)
  z2 = sample(1:K, n, replace = TRUE)
  
  A1 = sample_dcsbm(z1, B)
  A2 = sample_dcsbm(z2, B)#matrix(c(0.5,0.2,0.2,0.9),2,2) )
  
  z1hat = spec_clust(A1, K, niter = 30)
  z2hat = spec_clust(A2, K, niter = 30)
  B1hat = estim_dcsbm(A1, z1hat)$B
  B2hat = estim_dcsbm(A2, z2hat)$B
  
  Pt = matching(B1hat, B2hat, z1hat, z2hat)
  
  That_array[iter] = get_That(A1, A2, z1hat, z2hat, Pt)
  
  err1 = misclassification_rate(z1, z1hat)
  err2 = misclassification_rate(z2, z2hat)
  
  
  err1_array[iter] = err1
  err2_array[iter] = err2
}
