library(RSpectra)

ase <- function(A, d = 2){
  Asvd <- svds(A, d)
  Asvd$v %*% diag(sqrt(Asvd$d), d)
}

gaus_kernel <- function(x, y, sigma = 1){
  dif <- sum((x-y)^2)
  Kappa <- exp(-dif / sigma^2)
  Kappa
}
# use Gaussian Kernel w/ bandwidth = 1

agg_ase <- function(Alist, d){
  res <- matrix(0, 0, d)
  for (i in 1:length(Alist)){
    res <- rbind(res, ase(Alist[[i]], d))
  }
  res
}

l2norm_squared = function(X) Re(sum(Conj(t(X)) %*% X))

fast_mmd = function(X, Y,
                    sigvec = 10^seq(-2, 2, by = 0.2),
                    nBasis = 2^6, seed = NULL) {
  # The function use the Random Kitchen Sink idea (i.e., random Fourier
  # features) to compute the MMD based on a Gaussian kernel.
  # nBasis: Number of Fourier basis vectors
  
  if (!is.null(seed)) set.seed(seed)
  # rng('default');
  k0 = 1 # k0 = K(0,0)
  d = ncol(X)
  if (ncol(Y) != d) stop('# of columns of X and Y should match.')
  
  n = nrow(X)
  m = nrow(Y)
  N = nBasis
  
  Z = matrix(rnorm(N*d), nrow=N) # randn(N,d);
  # ZXt = Z %*% Matrix::t(X) # N x n
  # ZYt = Z %*% Matrix::t(Y) # N x m
  # ZXt = Matrix::t( X %*% t(Z) ) # N x n
  # ZYt = Matrix::t( Y %*% t(Z) ) # N x m
  ZXt = Z %*% t(as.matrix(X))
  ZYt = Z %*% t(as.matrix(Y))
  phi = function(sigma) rowMeans( exp(1i*ZXt/sigma) / sqrt(N))
  psi = function(sigma) rowMeans( exp(1i*ZYt/sigma) / sqrt(N))
  
  K = length(sigvec)
  biased = unbiased = rep(0, K)
  for (k in 1:K) {
    sigma = sigvec[k]
    u = phi(sigma)  # N x 1
    v = psi(sigma)  #  N x 1
    temp = l2norm_squared(u - v)
    biased[k] = sqrt(temp); #  norm(phi(sigma) - psi(sigma));
    unbiased[k] = temp + l2norm_squared(u)/(n-1) + l2norm_squared(v)/(m-1) - k0*(n+m-2)/(n-1)/(m-1)
    unbiased[k] = sqrt(max(unbiased[k],0))
  }
  list(biased = biased, unbiased = unbiased)
}
