# Install the 'clue' package if not already installed
if (!requireNamespace("clue", quietly = TRUE)) {
  install.packages("clue")
}

# Load the 'clue' package
library(clue)

# Function to compute cluster matching accuracy
cluster_matching_accuracy <- function(clustering1, clustering2) {
  # Create contingency matrix (confusion matrix)
  contingency_matrix <- table(clustering1, clustering2)
  
  # Use Hungarian algorithm to solve the linear assignment problem
  optimal_matching <- solve_LSAP(contingency_matrix, maximum = TRUE)
  
  # Compute the number of matched elements (sum of the diagonal elements of the confusion matrix)
  matched_elements <- sum(contingency_matrix[cbind(1:nrow(contingency_matrix), optimal_matching)])
  
  # Calculate the cluster matching accuracy
  matching_accuracy <- matched_elements / length(clustering1)
  
  return(matching_accuracy)
}

misclassification_rate <- function(clustering1, clustering2) {
  return(1-cluster_matching_accuracy(clustering1, clustering2))
}

# Test the function with two clustering labels
clustering1 <- c(1, 1, 2, 2, 3, 3)
clustering2 <- c(2, 2, 3, 3, 1, 4)

print(cluster_matching_accuracy(clustering1, clustering2))

print(misclassification_rate(clustering1, clustering2))


# Old code ----------------------------------------------------------------

#Find misclassification rate of zhat against z
#solving min_P z - zhat P 
#where z, zhat are n*K  membership matrices 
#misclassification_rate <-function(z, zhat, K){
#  z_mat <- label_vec2mat(z, K)
#  zhat_mat <- label_vec2mat(zhat, K)
#  confusion_cost <- t(zhat_mat) %*% z_mat
#  lp = lp.assign(confusion_cost, direction = "max")
#  perm <- lp$solution
#  label_mapping <- permutation_mapping(perm)
#  zhat_aligned = label_mapping[zhat]
#  return(sum(z != zhat_aligned)/length(z))
#}
