# Function to create a symmetric matrix with random uniform entries
runif_symmetric_matrix <- function(n, a, b) {
  # Create an empty nxn matrix
  result <- matrix(0, nrow = n, ncol = n)
  
  # Fill the lower triangular part of the matrix with random uniform values
  result[lower.tri(result, diag = TRUE)] <- runif(n * (n + 1) / 2, a, b)
  
  # Make the matrix symmetric by adding its transpose and subtracting the diagonal
  result <- result + t(result) - diag(diag(result))
  
  return(result)
}

# Function to create a symmetric matrix with random Gaussian entries
rnorm_symmetric_matrix <- function(n, mean, sd) {
  # Create an empty nxn matrix
  result <- matrix(0, nrow = n, ncol = n)
  
  # Fill the lower triangular part of the matrix with random Gaussian values
  result[lower.tri(result, diag = TRUE)] <- rnorm(n * (n + 1) / 2, mean, sd)
  
  # Make the matrix symmetric by adding its transpose and subtracting the diagonal
  result <- result + t(result) - diag(diag(result))
  
  return(result)
}


# # Function to create a symmetric matrix with random uniform entries
# rand_symmetric_matrix <- function(n, a, b) {
#   # Create an empty nxn matrix
#   result <- matrix(0, nrow = n, ncol = n)
# 
#   # Fill the lower triangular part of the matrix with random uniform values
#   result[lower.tri(result, diag = TRUE)] <- runif(n * (n + 1) / 2, a, b)
# 
#   # Copy the lower triangular part to the upper triangular part
#   result <- result + t(result) - diag(diag(result))
# 
#   return(result)
# }

