rm(list=ls())
setwd("~/two sample test")
source("R/accuracy.R")
source("R/matching.R")
source("R/generate.R")
source("R/checks.R")
source("R/hypot.R")
source("R/agg_functions.R")
source("R/ASE.R")
source("R/FPR_TPR.R")
source("R/graphon.R")


library(nett)
library(ggplot2)
library(igraph)

l2norm_squared = function(X) Re(sum(Conj(t(X)) %*% X))
sigma <- 0.01

num_reps <- 100

n <- 500

# x_i, y_i
num_anc_points <- 10
# dimensionality of x_i,y_i
d <- 4

rho <- 0.4
################################################################################
seed <- 1039

for (iter in 1:10){
  set.seed(seed+iter)
  
  # Generate pairs (x_i, y_i) from Normal
  x <- matrix(nrow = num_anc_points, ncol = d)
  y <- matrix(nrow = num_anc_points, ncol = d)
  for(j in 1:num_anc_points){
    x[j,] <- rnorm(d, 0, 1)
    y[j,] <- rnorm(d, 0, 1)
  }
  # Generate alpha_i
  alpha <- rnorm(num_anc_points, 0 , 1)
  eps_sigma <- rnorm(num_anc_points, 0, sigma)
  
  A1_null <- lapply(1:num_reps, function(i) sample_graphon_network(n, f, x, y, alpha, bw = 1, rho))
  A2_null <- lapply(1:num_reps, function(i) sample_graphon_network(n, f, x, y, alpha, bw = 1, rho))
  
  A1_alt <- lapply(1:num_reps, function(i) sample_graphon_network(n, f, x, y, alpha, bw = 1, rho))
  A2_alt <- lapply(1:num_reps, function(i) sample_graphon_network(n, f, x, y, alpha + eps_sigma, bw = 1, rho))
  
  saveRDS(A1_null, file=paste0("graphon_data/A1_null", seed+iter, ".RData"))
  saveRDS(A2_null, file=paste0("graphon_data/A2_null", seed+iter, ".RData"))
  saveRDS(A2_alt, file=paste0("graphon_data/A1_alt", seed+iter, ".RData"))
  saveRDS(A2_alt, file=paste0("graphon_data/A2_alt", seed+iter, ".RData"))
}


################################################################################


