library(sigmoid)
library(Rlab)
library(Matrix)

l2norm_squared = function(X) Re(sum(Conj(t(X)) %*% X))

# 2d Gaussian kernel
K<-function(a,b,c,d, bw = 1){
  r = exp(-l2norm_squared(c(a,b) - c(c,d))/(2*bw*bw))
  return(r)
}

# f:[0,1]^2 -> [0,1], given by f(u, v) = sigmoid(\sum_i \alpha_i K((x_i, y_i), (u,v)))
f<-function(u, v, x, y, alpha, bw = 1){
  res = 0
  for(i in 1:dim(x)[1]){
    res = res + alpha[i]*K(u, v, x[i,], y[i,], bw)
  }
  return(sigmoid(res))
}

# generate adjacency matrix A, 
# edge probability  given by sigmoid(f(v_i, v_j))

# n - number of vertices
sample_graphon_network<-function(n, f, x, y, alpha, bw = 1, rho = 1){
  d = dim(x)[2]
  # Assign v_i to vertex i
  v = matrix(0, nrow = n, ncol = d)
  for(i in 1:n){
    v[i,] = rnorm(d, 0, 1)
  }
  # init adj matrix
  A = matrix(0, nrow = n, ncol = n)
  for(i in 1:(n-1)){
    for(j in (i+1):n){
      A[i,j] = rbern(1, rho*f(v[i,], v[j,],  x, y, alpha, bw))
      A[j,i] = A[i,j]
    }
  }
  return(Matrix(A, sparse=TRUE))
}

# Graphon connectivity matrix
generate_graphon_conn<-function(k,x,y, alpha, bw){
  d = dim(x)[2]
  # Assign v_i to community i
  v = matrix(0, nrow = k, ncol = d)
  for(i in 1:k){
    v[i,] = rnorm(d, 0, 1)
  }
  
  P = matrix(0, nrow = k, ncol = k)
  for(i in 1:(k-1)){
    for(j in (i+1):k){
      P[i,j] = f(v[i,], v[j,],  x, y, alpha, bw)
      P[j,i] = P[i,j]
    }
  }
  return(P)
}

