count_vector_mismatches <- function(vec1, vec2, tolerance = 1e-8) {
  # Ensure vec1 and vec2 are vectors and have the same length
  if (!is.vector(vec1) || !is.vector(vec2)) {
    stop("Both vec1 and vec2 should be vectors")
  }

  if (length(vec1) != length(vec2)) {
    stop("vec1 and vec2 should have the same length")
  }

  # Count the number of mismatches
  num_mismatches = sum(abs(vec1 - vec2) > tolerance)

  # Return the number of mismatches
  return(num_mismatches)
}
