source("R/signs.R")
source("R/nett_revisions.R")
source("R/permutations.R")
source("R/lap.R")

#Matching B1hat against B2hat
matching <-function(B1hat, B2hat){
  # dont need this for newer version of R, e.g. 4.3.2+
  if (identical(B1hat, B2hat)){
    return(diag(1, nrow = dim(B1hat)[1]))
  }
  o1 <- eigen(B1hat)
  o2 <- eigen(B2hat)
  
  Q1 <- (o1$vectors) 
  Q2 <- (o2$vectors)  
  
  S_hat <- diag(recover_sign(Q1, Q2))
  
  Pt <- solve_lap((Q1) %*% S_hat %*% t(Q2))
  return(Pt)
}

