library(microbenchmark)

# Generate random permutation matrix
rand_perm_mat = function(K) {
  # diag(K)[, sample(K)]
  Matrix::Diagonal(K)[, sample(K)]
}

set.seed(42)
(P = rand_perm_mat(4))

# Convert permutation matrix into a map
permutation_mapping1 <- function(P) {
  max.col(P, ties.method = "first")
}

permutation_mapping2 <- function(P) {
  # as.integer(P %*% (1:nrow(P)))
  result <- as.matrix(P %*% (1:nrow(P)))
  as.integer(result)
}

benchmark_permutation_mapping <- function(min_dim, max_dim, step, repetitions = 100) {
  results <- list()
  
  for (dim in seq(min_dim, max_dim, step)) {
    P <- rand_perm_mat(dim)
    
    benchmark_result <- microbenchmark(
      permutation_mapping1(P),
      permutation_mapping2(P),
      times = repetitions
    )
    
    results[[as.character(dim)]] <- benchmark_result
  }
  
  return(results)
}

min_dim <- 2
max_dim <- 100
step <- 5
repetitions <- 100

results <- benchmark_permutation_mapping(min_dim, max_dim, step, repetitions)

library(ggplot2)

# Function to process and plot the benchmark results
plot_benchmark_results <- function(results) {
  # Convert the results to a data frame
  data <- do.call(rbind, lapply(names(results), function(dim) {
    df <- summary(results[[dim]])
    df$Dimension <- as.integer(dim)
    df$Function <- rownames(df)
    df
  }))
  
  # Create a ggplot object
  plot <- ggplot(data, aes(x = Dimension, y = mean, color = Function)) +
    geom_point() +
    geom_line() +
    labs(title = "Benchmark Results: Permutation Mapping Functions",
         x = "Matrix Dimension",
         y = "Execution Time (ns)") +
    theme_minimal() +
    # log y-axis
    scale_y_log10()
  
  return(plot)
}

plot <- plot_benchmark_results(results)
print(plot)
# save plot
ggsave("permutation_mapping_benchmark2.pdf", plot, width = 10, height = 6)


 # Old code ----------------------------------------------------------------

# #Generate random permutation matrix
# rand_perm_mat = function(K) {
#   Id = diag(K)
#   perm = sample(K,K)
#   Id[, perm]
# }
# 
# #convert permutation matrix into a map
# permutation_mapping <-function(P){
#   K = nrow(P)
#   zmap = rep(0, K)
#   for (i in 1:K){
#     for (j in 1:K){
#       if (P[i, j] != 0){
#         zmap[i] = j
#       }
#     }
#   }
#   return(zmap)
# }

