source("R/roc_curve.R")
set.seed(999)
K <- 16
B1 <- runif_symmetric_matrix(K, 0.3, 0.75)
n <- 4000
check_estim(B1, n)
n_sigma <- 5
sigma = seq(0.001, 0.01, length.out = n_sigma)
results <- data.frame(matrix(ncol = 3, nrow = 0))
colnames(results) <-  c("fpr", "tpr", "sigma")
for (i in 1:n_sigma){
  temp <- roc_curve_new(B1, sigma[i], num_iter = 100, num_thr = 15, n, labels = FALSE)
  results <- rbind(results, temp)
}
results$sigma <- as.factor(results$sigma)
ggplot(results, aes(x = fpr, y = tpr, color = sigma)) + 
  geom_line() +
  geom_abline(intercept = 0, slope = 1) +
  xlim(0, 1) +
  ylim(0, 1) +
  annotate("text", x = 0.75, y = 0.1, label = "K = 16, n = 2000")
