library(bcdc)

find_modes <- function(x) {
  # find the modes of a vector (the values with largest frequency)
  ux <- unique(x)
  tab <- tabulate(match(x, ux))
  ux[tab == max(tab)]
}

get_map_labels <- function(z_mat, burnin = NULL){
  niter = ncol(z_mat)
  if (is.null(burnin)) {
    burnin = round(niter/2)
  }
  
  z_mat = z_mat[,(burnin+1):niter]
  n = nrow(z_mat)
  z_map = sapply(1:n, function(i) find_modes(z_mat[i,])[1])
  confidence = sapply(1:n, function(i) sum(z_mat[i,] == z_map[i])/length(z_mat[i,]) )
  
  list(z_map = z_map, confidence = confidence, z_mat = z_mat)
}

baysian_community_detection <- function(A, K, niter = 500) {
  sbm_model <- new(SBM, A, K, .4, .4) # Create the model as an S4 object
  zout = sbm_model$run_gibbs(niter)
  get_map_labels(zout)$z_map
}