#find eps_delta parameters of B
get_eps_delta <-function(B){
  EVD = eigen(B)
  K = nrow(B)
  Q = (EVD$vectors)
  sums = colSums(Q)
  min_ = min(abs(sums))
  #max_ = max(abs(1/sums))
  #eps = min(min_, 1/max_)
  eps = min_
  
  Lambda = EVD$values
  K = nrow(B)
  delta = min(Lambda[-K] - Lambda[-1])
  
  return(c(eps, delta))
  
}

#check condition 19
check_estim <-function(B, n){
  chk = get_eps_delta(B)
  eps = chk[1]
  delta = chk[2]
  K = nrow(B)
  
  z = sample(1:K, n, replace = TRUE)
  A = sample_dcsbm(z, B)
  Bhat = estim_dcsbm(A, z)$B
  
  diff = norm(B - Bhat, type = "F")
  return(list("condition" = diff - eps*delta/(2*sqrt(2)*K), "eps" = eps, "delta" = delta))
}
