library(clue)

# Solve argmax tr(PQ)
# note: solve_LSAP(C) optimizes c_{i,j} X_{i,j} which is equal to tr(C^T X) = tr(X C^T)
solve_lap <- function(C) {
  min_value <- min(C)
  if (min_value < 0) {
    C <- C - min_value
  }
  optimal_matching <- solve_LSAP(t(C), maximum = TRUE)
  solution <- matrix(0, nrow = nrow(C), ncol = ncol(C))
  row_indices <- 1:nrow(C)
  solution[cbind(row_indices, optimal_matching)] <- 1
  return(solution)
}
