block_sums = function (A, z, diag_div = NULL) 
{
  # TODO: This only works correctly if the diagonal elements are zero
  # Check if the input matrix A is symmetric only if diag_div is not provided.
  if (is.null(diag_div)) {
    diag_div = isSymmetric(A)
  }
  
  # Extract the non-zero elements and their indices from the input matrix A.
  sA = Matrix::summary(A)
  temp = Matrix::sparseMatrix(i = z[sA$i], j = z[sA$j], x = sA$x)
  
  # Divide the diagonal elements by 2 if diag_div is TRUE.
  if (diag_div) {
    diag(temp) = diag(temp) / 2
  }
  
  # return(temp)
  return(as.matrix(temp))
}

block_sizes = function (z) 
{
  ns <- as.vector(table(z))
  
  temp = ns %*% t(ns)
  diag(temp) = (diag(temp) - ns)/2
  temp
}

