library(Matrix)

rperm <- function(K) {
  sample(K)
}

# Generate random permutation matrix
rand_perm_mat = function(K) {
  # diag(K)[, sample(K)]
  # Matrix::Diagonal(K)[, sample(K)]
  perm_to_mat(rperm(K))
}

perm2mat <- function(perm) {
  K <- length(perm)
  Matrix::Diagonal(K)[perm, ]
}

# Convert permutation matrix into a map
mat2perm <- function(P) {
  # as.integer(P %*% (1:nrow(P)))
  result <- as.matrix(P %*% (1:nrow(P)))
  as.integer(round(result))  # without rounding we get 0 1, instead of 1 2, as.integer rounds to zero.
}

permute_matrix <- function(mat, perm) {
  mat[perm, perm]
}

 # Old code ----------------------------------------------------------------

# #Generate random permutation matrix
# rand_perm_mat = function(K) {
#   Id = diag(K)
#   perm = sample(K,K)
#   Id[, perm]
# }
# 
# #convert permutation matrix into a map
# permutation_mapping <-function(P){
#   K = nrow(P)
#   zmap = rep(0, K)
#   for (i in 1:K){
#     for (j in 1:K){
#       if (P[i, j] != 0){
#         zmap[i] = j
#       }
#     }
#   }
#   return(zmap)
# }
