# Recover the sign matrix
recover_sign <- function(Q1, Q2) {
  # Ensure Q1 and Q2 are matrices
  if (!is.matrix(Q1) || !is.matrix(Q2)) {
    stop("Both Q1 and Q2 should be matrices")
  }
  
  # Ensure Q1 and Q2 have the same dimensions
  K = nrow(Q1)
  if (K != nrow(Q2)) {
    stop("Q1 and Q2 should have the same number of rows")
  }
  
  if (ncol(Q1) != ncol(Q2)) {
    stop("Q1 and Q2 should have the same number of columns")
  }
  
  # Compute the element-wise ratio of column sums
  col_ratios = colSums(Q2) / colSums(Q1)
  
  sign_vector = sign(col_ratios)
  
  return(sign_vector)
  # Create the sign matrix using the element-wise sign of col_ratios
  # sign_matrix = diag(sign(col_ratios))
  
  # Return the sign matrix
  # return(sign_matrix)
}


# Recover the sign matrix (old version)
recover_sign_old <- function(Q1, Q2) {
  K = nrow(Q1)
  if (K != nrow(Q2)) {
    step("Q1 and Q2 should have the same dimension")
  }
  temp = (t(Q2) %*% rep(1,K)) / (t(Q1) %*% rep(1,K))
  temp = as.vector(temp)
  sign(temp)
  # diag(sign(temp))
  # return(sign(matrix(Diagonal(K, matrix(S_hat)), K, K)))
}


