#include <RcppArmadillo.h>
// [[Rcpp::depends(RcppArmadillo)]]

using namespace Rcpp;

// [[Rcpp::export]]
arma::sp_mat sample_rdpg(const arma::mat& X, double lambda) {
  int n = X.n_rows;
  arma::sp_mat A(n, n);
  
  for (int i = 0; i < n; ++i) {
    for (int j = i + 1; j < n; ++j) {
      double prob = lambda * dot(X.row(i), X.row(j));
      if (R::runif(0, 1) < prob) {
        A(i, j) = 1;
        A(j, i) = 1; // Assuming undirected graph
      }
    }
  }
  
  return A;
}
