setwd("~/two sample test")
library(nett)
source("R/accuracy.R")
source("R/matching.R")
source("R/generate.R")
source("R/checks.R")
source("R/hypot.R")

set.seed(999)
K <- 12
B1 <- runif_symmetric_matrix(K, 0.25, 0.75)/15
eigen(B1)
B1

n <- 1000
num_reps <- 150
threshold <- 0
# Combine the list of data.frames into a single data.frame
res <- do.call(rbind, lapply(1:num_reps, function(rep_id) {
  z1 <- sample(1:K, n, replace = TRUE)
  z2 <- sample(1:K, n, replace = TRUE)
  A1 <- sample_dcsbm(z1, B1)
  A2 <- sample_dcsbm(z2, B1)
  
  z1hat <- spec_clust(A1, K, niter = 30)
  z2hat <- spec_clust(A2, K, niter = 30)
  # test_result <- sbm_tst(A1, A2, z1hat, z2hat)
  
  test_result <- sbm_tst_old(A1, A2, z1, z2, threshold)
  
  return(data.frame(rep = rep_id, tstat = test_result))
}))

# Plot the resulting distribution
library(ggplot2)
plt <- ggplot(res, aes(x = tstat)) + 
  geom_histogram(bins = 10, fill = "blue", alpha = 0.5) +
  xlab("SBM Test Result") + ylab("Frequency") +
  ggtitle(paste("Distribution of test statistic \n", "n = ", n, ", K = ", K))

print(plt)

print(ks.test(res$tstat, "pchisq", df = K * (K + 1) / 2))
