import numpy as np
from scipy.sparse import diags
import scipy.sparse as sp

def dataPreprocess(file_path, alpha = 0.2, random_seed = 0):
    np.random.seed(random_seed)
    A = sp.load_npz(file_path)
    D = diags(np.ravel(np.sum(A, axis=1)))
    Dhalf = diags(np.ravel(np.sqrt(np.sum(A, axis=1))))
    Dinv_half = diags(1 / np.sqrt(np.ravel(np.sum(A, axis=1))))
    Q = Dinv_half @ (D - 0.5 * (1 - alpha) * (D+A)) @ Dinv_half
    n = A.shape[0]
    s = np.random.normal(0, 1, n)
    s = s / np.sum(s)
    return Q, alpha, s, Dinv_half, Dhalf