# Script to filter weak and strong performances from phase 2 to phase 3
import json
import argparse
import os

def filter_performance(input_data, output_data):
    for category, tasks in input_data.items():
        if category not in output_data:
            output_data[category] = {}
        for task, performances in tasks.items():
            if task not in output_data[category]:
                output_data[category][task] = {}
            
            output_data[category][task]["Weak Performance"] = performances["Weak Performance"]
            output_data[category][task]["Strong Performance"] = performances["Strong Performance"]
    return output_data

parser = argparse.ArgumentParser(description='Filter the performance data')
parser.add_argument('input_file_path', type=str, help='Path to the JSON file containing the performance data')
parser.add_argument('output_file_path', type=str, default='filtered_performance_data.json', help='Path to the output JSON file')
args = parser.parse_args()

input_file_path = args.input_file_path
output_file_path = args.output_file_path

# Load the performance data from the input JSON file
with open(input_file_path, 'r') as f:
    input_data = json.load(f)

# Create output file path if it doesn't exist
output_dir = os.path.dirname(output_file_path)
if not os.path.exists(output_dir):
    os.makedirs(output_dir)

# Load data from the output JSON file if it exists
if os.path.exists(output_file_path):
    with open(output_file_path, 'r') as f:
        output_data = json.load(f)
else:
    output_data = {}

# Filter the data
updated_output_data = filter_performance(input_data, output_data)

with open(output_file_path, 'w') as f:
    json.dump(updated_output_data, f, indent=2)

print(f"Filtered performance data saved to {output_file_path}")