#!/bin/sh
CONFIG_FILE=training_none.yaml
for MPATH in EleutherAI/pythia-70m EleutherAI/pythia-160m EleutherAI/pythia-410m EleutherAI/pythia-1b EleutherAI/pythia-1.4b; do
  for EPSILON in 500; do
	for DS_NAME in enron; do
	   for DS_SIZE in 15000; do
		echo "${MPATH}, ${DS_NAME}, ${DS_SIZE}, ${EPSILON}, ${CONFIG_FILE}"
		export MPATH DS_NAME DS_SIZE EPSILON CONFIG_FILE
		sbatch -o logs/baseline_out_dname${DS_NAME}_dsize${DS_SIZE}_eps${EPSILON}.stdout.txt -e logs/baseline_out_dname${DS_NAME}_dsize${DS_SIZE}_eps${EPSILON}.stdout.txt train_eval.sbatch
		sleep 1 # pause to be kind to the scheduler
	   done
	done
  done 
done