#!/bin/sh
CONFIG_FILE=training_wts.yaml
# Use Python to extract the WEAK EPS value
YAML_VALUE=$(python -c "import yaml
with open('$CONFIG_FILE', 'r') as f:
    data = yaml.safe_load(f)
    print(data['WTS']['epsilon'])")

for MPATH in EleutherAI/pythia-410m; do
  for EPSILON in 100000000; do
	for DS_NAME in ag_news; do
	   for DS_SIZE in 10000; do
		echo "${MPATH}, ${DS_NAME}, ${DS_SIZE}, ${EPSILON}, ${CONFIG_FILE}, ${YAML_VALUE}"
		export MPATH DS_NAME DS_SIZE EPSILON CONFIG_FILE YAML_VALUE
		sbatch -o logs/wts_out_dname${DS_NAME}_dsize${DS_SIZE}_eps${EPSILON}_weakeps${YAML_VALUE}.stdout.txt -e logs/wts_out_dname${DS_NAME}_dsize${DS_SIZE}_eps${EPSILON}_weakeps${YAML_VALUE}.stdout.txt train_eval_memory.sbatch
		sleep 1 # pause to be kind to the scheduler
	   done
	done
  done 
done