#ifndef _ASM_X86_DELAY_H
#define _ASM_X86_DELAY_H

/* Undefined functions to get compile-time errors */
extern void __bad_udelay(void);
extern void __bad_ndelay(void);

extern void __udelay(unsigned long usecs);
extern void __ndelay(unsigned long nsecs);
extern void __const_udelay(unsigned long xloops);
extern void __delay(unsigned long loops);

/*
* The weird n/20000 thing suppresses a "comparison is always false due to
* limited range of data type" warning with non-const 8-bit arguments.
*/

/* 0x10c7 is 2**32 / 1000000 (rounded up) */
#define udelay(n)							\
({								\
  if (__builtin_constant_p(n)) {				\
    if ((n) / 20000 >= 1)				\
      __bad_udelay();			\
      else						\
      __const_udelay((n) * 0x10c7ul);		\
    } else {						\
      __udelay(n);					\
    }							\
  })

  /* 0x5 is 2**32 / 1000000000 (rounded up) */
  #define ndelay(n)							\
  ({								\
    if (__builtin_constant_p(n)) {				\
      if ((n) / 20000 >= 1)				\
        __bad_ndelay();				\
        else						\
        __const_udelay((n) * 5ul);		\
      } else {						\
        __ndelay(n);					\
      }							\
    })

void use_tsc_delay(void);

#endif /* _ASM_X86_DELAY_H */
