from pydantic import BaseModel
from functools import cached_property
import pandas as pd
from typing import List, Dict, Any, Optional, Literal, Union
from radar.data import perturb
from radar.data import datamodel


class PerturbationReturn(BaseModel):
    clean_data: Union[List[Dict[str, Any]], List[List[Dict[str, Any]]]]
    table_delta_spec: perturb.TableDeltaSpec
    artifact_types: List[datamodel.ArtifactType]
    artifact_scope: datamodel.ArtifactScope
    artifact_reasoning_cols: List[str]
    perturbation_note: Optional[str] = None

    @cached_property
    def clean_data_df(self) -> Union[pd.DataFrame, List[pd.DataFrame]]:
        if isinstance(self.clean_data, list) and isinstance(self.clean_data[0], list):
            return [pd.DataFrame(df) for df in self.clean_data]
        else:
            return pd.DataFrame(self.clean_data)

    @cached_property
    def perturbed_data_df(self) -> pd.DataFrame:
        if isinstance(self.clean_data_df, list):
            clean_data_df = self.clean_data_df[0]
        else:
            clean_data_df = self.clean_data_df

        return pd.DataFrame(
            perturb.apply_transform_spec(clean_data_df, self.table_delta_spec)
        )
