import os.path as osp
import time
from radar.logger import logger
import json


def get_src_dir():
    return osp.dirname(osp.abspath(__file__))


def get_project_dir():
    return osp.dirname(get_src_dir())


def get_conf_dir():
    return osp.join(get_project_dir(), "conf")


def format_bytes(num_bytes: int) -> str:
    """
    Format bytes into human readable string with appropriate unit (B, KB, MB, GB, TB).

    Args:
        num_bytes: Number of bytes to format

    Returns:
        Formatted string with appropriate unit
    """
    for unit in ["B", "KB", "MB", "GB", "TB"]:
        if num_bytes < 1024:
            if unit == "B":
                return f"{num_bytes} {unit}"
            return f"{num_bytes:.2f} {unit}"
        num_bytes /= 1024
    return f"{num_bytes:.2f} TB"


def read_json(path: str, time_it: bool = False):
    if time_it:
        start = time.time()
        file_size = osp.getsize(path)
        if file_size > 100:
            logger.info(
                f"Reading json file of size {format_bytes(file_size)} from {osp.basename(path)}"
            )
    with open(path, "r") as f:
        data = json.load(f)
    if time_it:
        end = time.time()
        logger.info(f"Time taken reading json: {end - start:.2f} seconds")
    return data
