# In-context Learning Over Graphs


## Running experiments

### Pretraining on MAG240M

```
python experiments/few_shot_demo/playground/run_single_experiment_v2.py --dataset mag240m --input_dim 768 --emb_dim 256 --root <DATA_ROOT> -ds_cap 50010 -val_cap 100 -test_cap 100 --epochs 1 -ckpt_step 1000 -layers S2,U,M -lr 3e-4 -way 30 -shot 3 -qry 4 -eval_step 500 --zero_label_embeddings True -task cls_nm --original_features True -bs 1 -aug ND0.5,NZ0.5 -aug_test True -attr 1000 --device 0
```

### Finetuning on ArXiv
```
python experiments/few_shot_demo/playground/run_single_experiment_v2.py --root <DATA_ROOT> --dataset arxiv --emb_dim 256 --input_dim 768 -ds_cap 5010 -val_cap 500 -test_cap 500 -eval_step 100 -epochs 1 --layers S2,U,M -way 3 -shot 3 -qry 3 -lr 1e-5 -bert roberta-base-nli-stsb-mean-tokens --no_split_labels True -pretrained <PATH_TO_CHECKPOINT> --eval_only True --train_cap 10 --zero_label_embeddings True --device 0
```


### Pretraining on Wiki

```
python experiments/few_shot_demo/playground/run_single_experiment_v2.py --dataset Wiki --input_dim 768 --emb_dim 256 --root ROOT -ds_cap 8010 -val_cap 10 -test_cap 10 --epochs 1 -ckpt_step 1000 -layers S2,UX,M2 -lr 1e-3 -way 15 -shot 3 -qry 4 -eval_step 500 --ignore_label_embeddings True -task cls_nm -bs 10 --device 0 --all_test True -meta_pos True -aug ND0.5,NZ0.5 -aug_test True -attr 1000 -ckpt_step 1000
```

### Finetuning on ConceptNet (4-way)
```
python experiments/few_shot_demo/playground/run_single_experiment_v2.py --root ROOT --dataset ConceptNet --emb_dim 256 -shot 3 --device 0 --input_dim 768 --layers S2,UX,M2 -ds_cap 1010 --eval_step 1000 --epochs 1 --dropout 0 --n_way 4 -bs 1 -qry 4 --ignore_label_embeddings True -lr 1e-4 --task multiway_classification -test_cap 500 -val_cap 10 --workers 15 -meta_pos True --eval_only True --all_test True --no_split_labels True --label_set 0 1 2 3 4 5 6 7 8 9 10 11 12 13 -train_cap 10 -pretrained <PATH_TO_CHECKPOINT>
```

