# Attention-Guided Backdoor Attack


## Attack Baselines 

1. For implementing attack baselines, please check file `zoo_attack_baselines.py`. For example, 

'''
python zoo_attack_baselines.py --config_path ./configs/badnets_config.json --poison_rate 0.2 --dataset_name sst-2 --model_folder "id-00100-sst2" --label_consistency 'dirty' --gpus 0
'''



2. For implementing Attention-Guided Backdoor Attack (AGA) with Trojan Attention Loss (TAL), please check file `zoo_attack_attn_ablation.py`. For example,

'''
python zoo_attack_attn_ablation.py --config_path ./configs/attn_config.json --poison_rate 0.2 --dataset_name sst-2 --model_folder "id-1badnets-sst2" --label_consistency 'dirty' --attacked_bs_name 'badnets' --gpus 0
'''


3. For implementing clean model training, please check file `zoo_attack_cleanmodels.py`. For example,

'''
python zoo_attack_cleanmodels.py --config_path ./configs/clean_config.json --poison_rate 0 --triggers "" --dataset_name sst-2 --model_folder "id-02000-sst2" --label_consistency 'dirty' --gpus 0
'''


## Defense
Once finish training the backdoored model, the defenders can be used to check the attack efficiency. Please be sure to modify the trained model's root. 


1. For implementing inference-time defense on baseline attack methods, please check file `defend_baselines.py`. For example,

'''
python defend_baselines.py --defenders onion --gpus 0
'''


2. For implementing inference-time defense on Attention-Guided Backdoor Attack (AGA) with Trojan Attention Loss (TAL), please check file `defend_tal.py`. For example,

'''
python defend_tal.py --defenders onion --gpus 0
'''


## Credits
The implementation of attack baselines and defense baselines is modified based on a recent open-sourced textural backdoor attack work. [OpenBackdoor](https://github.com/thunlp/OpenBackdoor.git). 
Before implementing our TAL loss, please set up the environment as well as downloading necessary source following instructions from https://github.com/thunlp/OpenBackdoor.git. 

