from .attacker import Attacker
from .ep_attacker import EPAttacker
from .attn_attacker import AttnAttacker
from .attn_ep_attacker import AttnEPAttacker
from .clean_attacker import CleanAttacker


ATTACKERS = {
    "clean": CleanAttacker,
    "base": Attacker,
    "badnets": Attacker,
    "addsent": Attacker,
    "trojanlm": Attacker,
    "ep": EPAttacker,
    "synbkd": Attacker,
    "stylebkd": Attacker,
    "attn": AttnAttacker,
    "attn_badnets": AttnAttacker,
    "attn_addsent": AttnAttacker,
    "attn_ep": AttnEPAttacker,
    "attn_stylebkd": AttnAttacker,
    "attn_synbkd": AttnAttacker

}


def load_attacker(config):
    return ATTACKERS[config["name"].lower()](**config)
