# metamer & readout representation

This repository contains experiment codes that investigate neural representation by reading-out information from neural activities.



## Preparation
1. **Install dependencies.** Dependencies are specified in `pyproject.toml` file. I recommend using `uv` or other package managers to install dependencies.
2. **Download model weights (optional).** If you want to perform an experiment with VGG19 with the same weights we have used, please download its weights from the link specified in the paper, and plase it as `data/models/vgg19-lab/VGG_ILSVRC_19_layers.pt`.

## Directories
```
data/           # data
scripts/        # store scripts for experiments
src/            # store codes that is shared across experiments
```

## Experiments
Each expeirment has an unique directory under `scripts`. Config files and analysis notebooks are all stored under the expeirmnet directory.
- `scripts/readout_vision`: Reconstruct images from original and perturbed features of vision models.
- `scripts/readout_language`: Reconstruct texts from original and perturbed features.
- `scripts/toy_model`: Toy model experiment.
- `scripts/readout_vae`: Reconstruct images from original and perturbed features of VAE using decoder forwarding.



