"""
Metrics for evaluating the size of representation.
"""
import numpy as np
import pandas as pd

def calculate_size_of_representation(
        experiment_db: pd.DataFrame,
        t: float,
        dp_col: str = 'pixel_correlation_distance',
        dh_col: str = 'true_target_feature_correlation_distance',
    ):
    """
    Calculate the size of representation for each layer

    Args:
        experiment_db (pd.DataFrame): The experiment database containing the results.
        t (float): The threshold for pixel correlation distance.
        clm_name (str): The name of the column to be used for distance metric.

    Returns:
        pd.DataFrame: A DataFrame containing the size of representation for each layer and image.
    """
    df = experiment_db[experiment_db[dp_col] < t]
    # get the size of representation
    size = df.groupby(['layer', 'name'])[dh_col].max().reset_index()
    return size