# STAF: Sinusoidal Trainable Activation Functions for Implicit Neural Representation

This directory contains the source code and additional materials for the STAF simulations presented in our submission. The provided code demonstrates the implementation of the STAF model and reproduces the results discussed in the paper.

## Environment and Dependencies

The code is compatible with Python '3.8.6' and has been tested on both CPU and GPU environments. To ensure compatibility and ease of setup, it is recommended to use a virtual environment.

## Installation

Create a Virtual Environment (Optional):
It's recommended to create a virtual environment to avoid conflicts with existing installations. Use the following commands:

```sh
python -m venv STAF # On Windows, use `paracnet_env\Scripts\activate`
```

## Install Dependencies:

Navigate to the cloned repository's directory and install the required dependencies:

```sh
pip install -r requirements.txt
```

## Running the Code

Execute Main Script:
To run the main simulation and reproduce the results, execute the main.py script:

```sh
python main.py
```

## Viewing Results:

The results of the simulation, will be displayed in the console and saved in the project folder.
