## Instructions
- Install [Mujoco](http://www.mujoco.org/) based on the instructions given [here](https://github.com/facebookresearch/drqv2).
- Install the following libraries:
```
sudo apt update
sudo apt install libosmesa6-dev libgl1-mesa-glx libglfw3
```
- Install dependencies
  - Set up Environment
  ```
  conda env create -f conda_env.yml
  conda activate rot
  ```
  - Install Meta-World
  ```
  pip install -e /path/to/dir/metaworld
  ```

- You can generate the expert demonstrations through `metaworld_generate_expert/generate_demo.py`.
- Run experiments by the following command:
  ```
  python train.py agent=potil suite=metaworld obs_type=pixels suite/metaworld_task=assembly num_demos=10 seed=10 bc_regularize=false suite.num_train_frames=2000000 agent.rewards=sinkhorn_cosine load_bc=false suite.eval_every_frames=10000 agent.auto_rew_scale_wo_truncate=true agent.expl_noise=0.4 adaptive_discount=true adaptive_discount_mode='lis' adaptive_discount_paras=0.2 adaptive_progress_threshold=0.9 max_progress_delta=5 progress_guide_start=0.1 ref_score_percentile=50 agent_score_percentile=90
  ```