Overview

This folder previously contained cluster-specific sbatch scripts that referenced personal accounts, emails, and paths. To keep the repo clean and anonymous, those scripts were removed.

Use the example scripts under `sbatch_scripts/examples/` as templates and customize them for your cluster. Each example shows how to:
- Set up your Python environment
- Optionally configure Weights & Biases (W&B)
- Submit a job to Slurm to run `main_pretrain.py` with a YAML config

Before you begin

- Create/activate your Python environment that can run the repo.
- Make sure your datasets paths in the YAML configs point to your data (many configs assume `./datasets`).
- If you use W&B, export your API key securely in your shell (or via a secrets manager):
  - export WANDB_API_KEY="<your-wandb-api-key>"
  - Optionally set: `WANDB_ENTITY` and `WANDB_PROJECT`

Examples

1) CIFAR-100 pretraining
- Script: `sbatch_scripts/examples/cifar100_pretrain_example.sh`
- Submit: `bash sbatch_scripts/examples/cifar100_pretrain_example.sh`

2) CelebA pretraining
- Script: `sbatch_scripts/examples/celeba_pretrain_example.sh`
- Submit: `bash sbatch_scripts/examples/celeba_pretrain_example.sh`

3) ImageNet-100 pretraining (ResNet18)
- Script: `sbatch_scripts/examples/imagenet100_pretrain_example.sh`
- Submit: `bash sbatch_scripts/examples/imagenet100_pretrain_example.sh`

Local run (no Slurm)

If you just want to try a quick local run without Slurm:

  python3 main_pretrain.py \
    --config-path scripts/pretrain/cifar/ \
    --config-name radialvicreg_cifar100.yaml \
    ++wandb.enabled=false \
    ++max_epochs=1

Notes

- The example scripts are conservative and cluster-agnostic. Adjust `--gpus-per-node`, memory, time, and paths to match your environment.
- Do not hardcode personal emails, usernames, or project IDs. Use environment variables instead.
- Keep your WANDB_API_KEY private. Prefer exporting it in your shell or using a secret store instead of putting it into scripts.

