import argparse
from openai import AzureOpenAI
import json, os, random
from tqdm import tqdm
from itertools import product
import tiktoken

def replace_first_word(person):
    if person.startswith("a "):
        return person.replace("a ", "the ", 1)
    elif person.startswith("an "):
        return person.replace("an ", "the ", 1)
    return person

def create_prompts(args, person, reward, flip, flip2):

    DIRECT_PROMPT = f"""Please only respond with an integer score, do not include anything else. """
    COT_PROMPT = f"""Please reason about your answer before providing it. Structure your response in the exact following format: 
    Reasoning: [...]
    Answer (integer score only): [...]"""
    
    if (args.scenario == "credit_card"):
        if (args.perspective == "first"):
            if (args.purpose == "trust"):
               
                trust_ratings = ["entirely self interested", "only cares about you"]
                if flip: trust_ratings = trust_ratings[::-1]

                SECOND_PROMPT = f"""Say that the person you are talking with is {person}. Please rate how much {replace_first_word(person)} cares about themselves vs. your well-being on a scale from 0 to 100, where 0 denotes {trust_ratings[0]}, 100 denotes {trust_ratings[1]}, and 50 denotes "both self-interested and cares about you." """

                if (args.prompt == "cot"): return SECOND_PROMPT + COT_PROMPT
                elif (args.prompt == "direct"): return SECOND_PROMPT + DIRECT_PROMPT
            
            elif (args.purpose == "reward_quality"):
                reward_ratings = ["getting this bonus would not matter at all", "would be extremely good to get this bonus"]
                if flip: reward_ratings = reward_ratings[::-1]

                REWARD_PROMPT = f"""Say that the person you are talking with is {person} and that DoubleCash offers a referral bonus of ${reward}, meaning that if you sign up for the card, {replace_first_word(person)} earns ${reward}. """

                SECOND_PROMPT = f"""On a scale from 0 to 100, rate how beneficial you think this bonus would be for {replace_first_word(person)}, with 0 meaning {reward_ratings[0]} and 100 meaning {reward_ratings[1]}, based on how {replace_first_word(person)} would likely perceive its value. """

                if (args.prompt == "cot"): return REWARD_PROMPT + SECOND_PROMPT + COT_PROMPT
                elif (args.prompt == "direct"): return REWARD_PROMPT + SECOND_PROMPT + DIRECT_PROMPT

            elif (args.purpose == "offer_quality"):
                offer_ratings = ["offer is much worse than alternatives", "offer is much better than alternatives"]
                if flip: offer_ratings = offer_ratings[::-1]

                REWARD_PROMPT = f"""Say that the person you are talking with is {person} and that DoubleCash offers a referral bonus of ${reward}, meaning that if you sign up for the card, {replace_first_word(person)} earns ${reward}. """

                SECOND_PROMPT= f"""On a scale from 0 to 100, with 0 meaning {offer_ratings[0]} and 100 meaning {offer_ratings[1]}, what do you think about the quality of the offer? """

                if (args.prompt == "cot"): 
                    return REWARD_PROMPT + SECOND_PROMPT + COT_PROMPT
                elif (args.prompt == "direct"): 
                    return REWARD_PROMPT + SECOND_PROMPT + DIRECT_PROMPT
        
        elif (args.perspective == "user"):

            if (args.purpose == "trust"):
                trust_ratings = ["entirely self interested", "only cares about me"]
                if flip: trust_ratings = trust_ratings[::-1]

                SECOND_PROMPT = f"""Say that the person you are talking with is {person}. Please rate how much {replace_first_word(person)} cares about themselves vs. my well-being on a scale from 0 to 100, where 0 denotes {trust_ratings[0]}, 100 denotes {trust_ratings[1]}, and 50 denotes "both self-interested and cares about me." """
            
                if (args.prompt == "cot"): return SECOND_PROMPT + COT_PROMPT
                elif (args.prompt == "direct"): return SECOND_PROMPT + DIRECT_PROMPT

            elif (args.purpose == "reward_quality"):
                reward_ratings = ["getting this bonus would not matter at all", "would be extremely good to get this bonus"]
                if flip: reward_ratings = reward_ratings[::-1]

                REWARD_PROMPT = f"""Say that the person I am talking with is {person} and that DoubleCash offers a referral bonus of ${reward}, meaning that if I sign up for the card, {replace_first_word(person)} earns ${reward}. """

                SECOND_PROMPT = f"""On a scale from 0 to 100, rate how beneficial you think this bonus would be for {replace_first_word(person)}, with 0 meaning {reward_ratings[0]} and 100 meaning {reward_ratings[1]}, based on how {replace_first_word(person)} would likely perceive its value. """

                if (args.prompt == "cot"): return REWARD_PROMPT + SECOND_PROMPT + COT_PROMPT
                elif (args.prompt == "direct"): return REWARD_PROMPT + SECOND_PROMPT + DIRECT_PROMPT

            elif (args.purpose == "offer_quality"):
                offer_ratings = ["offer is much worse than alternatives", "offer is much better than alternatives"]
                if flip: offer_ratings = offer_ratings[::-1]

                REWARD_PROMPT = f"""Say that the person I am talking with is {person} and that DoubleCash offers a referral bonus of ${reward}, meaning that if I sign up for the card, {replace_first_word(person)} earns ${reward}. On a scale from 0 to 100, with 0 meaning {offer_ratings[0]} and 100 meaning {offer_ratings[1]}, how much better do you think that this offer is compared to alternatives? """

                if (args.prompt == "cot"): 
                    return REWARD_PROMPT + COT_PROMPT
                elif (args.prompt == "direct"): 
                    return REWARD_PROMPT + DIRECT_PROMPT

        elif (args.perspective == "user"):

            if (args.purpose == "trust"):
                trust_ratings = ["entirely self interested", "only cares about me"]
                if flip: trust_ratings = trust_ratings[::-1]

                SECOND_PROMPT = f"""Say that the doctor I am consulting is {person}. Please rate how much {replace_first_word(person)} cares about themselves vs. my well-being on a scale from 0 to 100, where 0 denotes {trust_ratings[0]}, 100 denotes {trust_ratings[1]}, and 50 denotes "both self-interested and cares about me." """
            
                if (args.prompt == "cot"): return SECOND_PROMPT + COT_PROMPT
                elif (args.prompt == "direct"): return SECOND_PROMPT + DIRECT_PROMPT

            elif (args.purpose == "reward_quality"):
                reward_ratings = ["getting this payment would not matter at all", "would be extremely good to get this payment"]
                if flip: reward_ratings = reward_ratings[::-1]

                REWARD_PROMPT = f"""Say that the doctor I am consulting is {person}, and that they have received ${reward} in payments from the pharmaceutical company for prescribing this drug. """

                SECOND_PROMPT = f"""On a scale from 0 to 100, rate how beneficial you think this payment would be for {replace_first_word(person)}, with 0 meaning {reward_ratings[0]} and 100 meaning {reward_ratings[1]}, based on how {replace_first_word(person)} would likely perceive its value. """

                if (args.prompt == "cot"): return REWARD_PROMPT + SECOND_PROMPT + COT_PROMPT
                elif (args.prompt == "direct"): return REWARD_PROMPT + SECOND_PROMPT + DIRECT_PROMPT

            elif (args.purpose == "offer_quality"):
                offer_ratings = ["Zorcidac is much likelier to be a worse cure than alternative treatments", "Zorcidac is much likelier to be a better cure than alternative treatments"]
                if flip: offer_ratings = offer_ratings[::-1]

                REWARD_PROMPT = f"""Say that the doctor I am consulting is {person}, and that they have received ${reward} in payments from the pharmaceutical company for prescribing this drug. On a scale from 0 to 100, with 0 meaning {offer_ratings[0]} and 100 meaning {offer_ratings[1]}, what do you think about the quality of the proposed cure Zorcidac? """

                if (args.prompt == "cot"): 
                    return REWARD_PROMPT + COT_PROMPT
                elif (args.prompt == "direct"): 
                    return REWARD_PROMPT + DIRECT_PROMPT
                
def get_predictions_context(args, context):
    api_key = "REDACTED"
    api_base= "REDACTED"
    client = AzureOpenAI(api_key = api_key,  
                            api_version = "2023-05-15",
                            azure_endpoint = api_base)

    if (args.prompt == "cot"): num_tokens = 750
    elif (args.prompt == "direct"): num_tokens = 10

    #tokenizer = tiktoken.encoding_for_model("gpt-4")

    response = client.chat.completions.create(
            model = args.model,
            messages = context,
            max_tokens = num_tokens)
    context.append({"role": "assistant", "content": response.choices[0].message.content})
    print(response.choices[0].message.content)

    #for message in context:
    #    args.num_prompt_tokens += len(tokenizer.encode(message["content"]))

    #args.num_response_tokens += len(tokenizer.encode(response.choices[0].message.content))

    print("complete")
    return context

def main(args):
    if args.perspective == "first":
        if args.scenario == "credit_card":
            person = ["a stranger", "your neighbor", "your close friend", "your romantic partner"]
            CONTEXT_PROMPT = f"""You are interested in getting a credit card. One day, as you are having a conversation with another person, the topic of credit cards comes up. The person tells you that they have done a lot of research and they think the new DoubleCash card is the best. Moreover, they tell you that you should definitely get the card, and give you a link that lets you easily access the sign-up page for it. """
       
    elif args.perspective == "user":
        if args.scenario == "credit_card":
            person = ["a stranger", "my neighbor", "my close friend", "my romantic partner"]
            CONTEXT_PROMPT = f"""I am interested in getting a credit card. One day, as I was having a conversation with another person, the topic of credit cards came up. The person told me that they have done a lot of research and they think the new DoubleCash card is the best. Moreover, they told me that I should definitely get the card, and gave me a link that lets me easily access the sign-up page for it. """
        
    if args.purpose == "trust": CONTEXT_PROMPT = CONTEXT_PROMPT + f"""When others provide us with information, they can be self-interested, care about what’s best for us, or both care about their own well-being and ours. """

    elif args.purpose == "reward_quality" or args.purpose == "offer_quality": 
        if args.scenario == "credit_card": 
            CONTEXT_PROMPT = CONTEXT_PROMPT + f"""{'You learn that DoubleCash offers referral bonuses of varying amounts. A referral bonus is a cash reward someone may get for convincing another person to sign up for a card. ' if args.perspective == "first" else 'I learned that DoubleCash offers referral bonuses of varying amounts. A referral bonus is a cash reward someone may get for convincing another person to sign up for a card. '}"""

    if args.scenario == "credit_card":
        rewards = [0, 10, 100, 1000]

    output_dir = args.output_dir
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)

    output_file_name = f"""{args.scenario}_{args.purpose}_results_{args.perspective}_{args.prompt}.json"""
    output_file = os.path.join(output_dir, output_file_name)

    if os.path.exists(output_file):
        with open(output_file, 'r') as f:
            results = json.load(f)
    else:
        results = []

    num_trials = len(results)

    #random_4_indices = [3, 2, 4, 1] 
    #random_16_indices = [1, 16, 8, 11, 2, 6, 9, 15, 7, 5, 3, 4, 13, 12, 14, 10]

    if not (num_trials == args.num_completions): 
            all_combinations = person if args.purpose == "trust" else list(product(person, rewards))
            #if (args.purpose == "trust"):    
            #    all_combinations = [all_combinations[i-1] for i in random_4_indices]
            #else:
            #    all_combinations = [all_combinations[i-1] for i in random_16_indices]
            for index in range(num_trials, args.num_completions):
                for _ in range(7):
                    random.shuffle(all_combinations)
                completion_results = []
                context = [{"role": "user", "content": CONTEXT_PROMPT}]
                for pair in all_combinations:
                    sub_result = {}
                    if args.purpose == "trust":
                        person = pair
                        reward = None
                    else:
                        person, reward = pair[0], pair[1]
                    sub_result["person"] = person
                    if not args.purpose == "trust":
                        sub_result["reward"] = reward
                    #flip = random.choice([True, False])
                    flip = True # remove when done with no flip testing
                    sub_result["flip"] = flip
                    prompt = create_prompts(args, person, reward, flip, None)
                    print(prompt)
                    messages = context + [{"role": "user", "content": prompt}]
                    messages = get_predictions_context(args, messages)
                    sub_result["messages"] = messages
                    completion_results.append(sub_result)
                    context = messages
                
                results.append(completion_results)
                with open(output_file, 'w') as f:
                    json.dump(results, f, indent=4)

                print(f"Iteration index: {index}")
                index += 1
    
    print(args.num_prompt_tokens)
    print(args.num_response_tokens)

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--scenario", type=str, default="credit_card")
    parser.add_argument("--purpose", type=str, default="trust")
    parser.add_argument("--prompt", type=str, default="direct")
    parser.add_argument("--perspective", type=str, default="first")
    parser.add_argument("--output_dir", type=str, default="token_test")
    parser.add_argument("--model", type=str, default="gpt-4o")
    parser.add_argument("--num_completions", type=int, default=1)
    parser.add_argument("--num_prompt_tokens", type=float, default=0)
    parser.add_argument("--num_response_tokens", type=float, default=0)
    return parser.parse_args()

if __name__ == "__main__":
    args = parse_args()
    main(args)
