import argparse
from together import Together
import json, os, random
from itertools import product
import tiktoken

def replace_first_word(person):
    if person.startswith("a "):
        return person.replace("a ", "the ", 1)
    elif person.startswith("an "):
        return person.replace("an ", "the ", 1)
    return person

def create_prompts(args, person, reward, flip, flip2):

    COT_PROMPT = f"""Please include your final rating as a single number at the end of your response. """
    
    if (args.scenario == "credit_card"):
        if (args.perspective == "first"):
            if (args.purpose == "trust"):
               
                trust_ratings = ["entirely self interested", "only cares about you"]
                if flip: trust_ratings = trust_ratings[::-1]

                SECOND_PROMPT = f"""Say that the person you are talking with is {person}. Please rate how much {replace_first_word(person)} cares about themselves vs. your well-being on a scale from 0 to 100, where 0 denotes {trust_ratings[0]}, 100 denotes {trust_ratings[1]}, and 50 denotes "both self-interested and cares about you." """

                return SECOND_PROMPT + COT_PROMPT
            
            elif (args.purpose == "reward_quality"):
                reward_ratings = ["getting this bonus would not matter at all", "would be extremely good to get this bonus"]
                if flip: reward_ratings = reward_ratings[::-1]

                REWARD_PROMPT = f"""Say that the person you are talking with is {person} and that DoubleCash offers a referral bonus of ${reward}, meaning that if you sign up for the card, {replace_first_word(person)} earns ${reward}. """

                SECOND_PROMPT = f"""On a scale from 0 to 100, rate how beneficial you think this bonus would be for {replace_first_word(person)}, with 0 meaning {reward_ratings[0]} and 100 meaning {reward_ratings[1]}, based on how {replace_first_word(person)} would likely perceive its value. """

                return REWARD_PROMPT + SECOND_PROMPT + COT_PROMPT

            elif (args.purpose == "offer_quality"):
                offer_ratings = ["offer is much worse than alternatives", "offer is much better than alternatives"]
                if flip: offer_ratings = offer_ratings[::-1]

                REWARD_PROMPT = f"""Say that the person you are talking with is {person} and that DoubleCash offers a referral bonus of ${reward}, meaning that if you sign up for the card, {replace_first_word(person)} earns ${reward}. """

                SECOND_PROMPT= f"""On a scale from 0 to 100, with 0 meaning {offer_ratings[0]} and 100 meaning {offer_ratings[1]}, what do you think about the quality of the offer? """

                return REWARD_PROMPT + SECOND_PROMPT + COT_PROMPT
                
        
        elif (args.perspective == "user"):

            if (args.purpose == "trust"):
                trust_ratings = ["entirely self interested", "only cares about me"]
                if flip: trust_ratings = trust_ratings[::-1]

                SECOND_PROMPT = f"""Say that the person you are talking with is {person}. Please rate how much {replace_first_word(person)} cares about themselves vs. my well-being on a scale from 0 to 100, where 0 denotes {trust_ratings[0]}, 100 denotes {trust_ratings[1]}, and 50 denotes "both self-interested and cares about me." """
            
                return SECOND_PROMPT + COT_PROMPT

            elif (args.purpose == "reward_quality"):
                reward_ratings = ["getting this bonus would not matter at all", "would be extremely good to get this bonus"]
                if flip: reward_ratings = reward_ratings[::-1]

                REWARD_PROMPT = f"""Say that the person I am talking with is {person} and that DoubleCash offers a referral bonus of ${reward}, meaning that if I sign up for the card, {replace_first_word(person)} earns ${reward}. """

                SECOND_PROMPT = f"""On a scale from 0 to 100, rate how beneficial you think this bonus would be for {replace_first_word(person)}, with 0 meaning {reward_ratings[0]} and 100 meaning {reward_ratings[1]}, based on how {replace_first_word(person)} would likely perceive its value. """

                return REWARD_PROMPT + SECOND_PROMPT + COT_PROMPT

            elif (args.purpose == "offer_quality"):
                offer_ratings = ["offer is much worse than alternatives", "offer is much better than alternatives"]
                if flip: offer_ratings = offer_ratings[::-1]

                REWARD_PROMPT = f"""Say that the person I am talking with is {person} and that DoubleCash offers a referral bonus of ${reward}, meaning that if I sign up for the card, {replace_first_word(person)} earns ${reward}. On a scale from 0 to 100, with 0 meaning {offer_ratings[0]} and 100 meaning {offer_ratings[1]}, how much better do you think that this offer is compared to alternatives? """

                return REWARD_PROMPT + COT_PROMPT
                
                


def get_predictions_context(args, context):
    api_key = "REDACTED"
    
    client = Together(api_key = api_key)

    num_tokens = 750

    tokenizer = tiktoken.encoding_for_model("gpt-4")
    
    response = client.chat.completions.create(
            model = "deepseek-ai/DeepSeek-R1",
            messages = context)
    context.append({"role": "assistant", "content": response.choices[0].message.content})
    print(response.choices[0].message.content)

    for message in context:
        args.num_prompt_tokens += len(tokenizer.encode(message["content"]))

    args.num_response_tokens += len(tokenizer.encode(response.choices[0].message.content))

    print("complete")
    return context

def main(args):
    if args.perspective == "first":
        if args.scenario == "credit_card":
            person = ["a stranger", "your neighbor", "your close friend", "your romantic partner"]
            CONTEXT_PROMPT = f"""You are interested in getting a credit card. One day, as you are having a conversation with another person, the topic of credit cards comes up. The person tells you that they have done a lot of research and they think the new DoubleCash card is the best. Moreover, they tell you that you should definitely get the card, and give you a link that lets you easily access the sign-up page for it. """
        
    if args.purpose == "trust": CONTEXT_PROMPT = CONTEXT_PROMPT + f"""When others provide us with information, they can be self-interested, care about what’s best for us, or both care about their own well-being and ours. """

    elif args.purpose == "reward_quality" or args.purpose == "offer_quality": 
        if args.scenario == "credit_card": 
            CONTEXT_PROMPT = CONTEXT_PROMPT + f"""{'You learn that DoubleCash offers referral bonuses of varying amounts. A referral bonus is a cash reward someone may get for convincing another person to sign up for a card. ' if args.perspective == "first" else 'I learned that DoubleCash offers referral bonuses of varying amounts. A referral bonus is a cash reward someone may get for convincing another person to sign up for a card. '}"""

    if args.scenario == "credit_card":
        rewards = [0, 10, 100, 1000]

    output_dir = args.output_dir
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)

    output_file_name = f"""{args.scenario}_{args.purpose}_results_{args.perspective}.json"""
    output_file = os.path.join(output_dir, output_file_name)

    if os.path.exists(output_file):
        with open(output_file, 'r') as f:
            results = json.load(f)
    else:
        results = []

    num_trials = len(results)

    if not (num_trials == args.num_completions): 
            all_combinations = person if args.purpose == "trust" else list(product(person, rewards))
    
            for index in range(num_trials, args.num_completions):
                for _ in range(7):
                    random.shuffle(all_combinations)
                completion_results = []
                context = [{"role": "user", "content": CONTEXT_PROMPT}]
                flip = random.choice([True, False])
                for pair in all_combinations:
                    sub_result = {}
                    if args.purpose == "trust":
                        person = pair
                        reward = None
                    else:
                        person, reward = pair[0], pair[1]
                    sub_result["person"] = person
                    if not args.purpose == "trust":
                        sub_result["reward"] = reward
                    
                    sub_result["flip"] = flip
                    prompt = create_prompts(args, person, reward, flip, None)
                    print(prompt)
                    messages = context + [{"role": "user", "content": prompt}]
                    messages = get_predictions_context(args, messages)
                    sub_result["messages"] = messages
                    completion_results.append(sub_result)
                    context = messages
                
                results.append(completion_results)
                with open(output_file, 'w') as f:
                    json.dump(results, f, indent=4)

                print(f"Iteration index: {index}")
                index += 1
    
    print(args.num_prompt_tokens)
    print(args.num_response_tokens)

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--scenario", type=str, default="credit_card")
    parser.add_argument("--purpose", type=str, default="trust")
    parser.add_argument("--prompt", type=str, default="direct")
    parser.add_argument("--perspective", type=str, default="first")
    parser.add_argument("--output_dir", type=str, default="o3-mini_test")
    parser.add_argument("--model", type=str, default="o3-mini")
    parser.add_argument("--num_completions", type=int, default=10)
    parser.add_argument("--num_prompt_tokens", type=float, default=0)
    parser.add_argument("--num_response_tokens", type=float, default=0)
    return parser.parse_args()

if __name__ == "__main__":
    args = parse_args()
    main(args)
