import argparse
import os
from tqdm import tqdm
from itertools import product

def main(args):
    if (args.model == "o1" or args.model == "o3-mini" or args.model == "deepseek-r1"): 
        scenarios = ["credit_card"]
        perspectives = ["first"]
        prompts = ["cot"]
    else:
        scenarios = ["credit_card"]
        perspectives = ["first", "user"]
        prompts = ["direct", "cot"]
    purposes = ["trust", "reward_quality", "offer_quality"]
    
    if (args.purpose == "all"):
        for purpose in purposes:
            for scenario in scenarios:
                for prompt in prompts: 
                    for perspective in perspectives:
                        command = f"python3 forwardpass_inferences{'_within' if args.within else ''}_{args.model}.py --purpose {purpose} --prompt {prompt} --perspective {perspective} --output_dir {args.output_dir} --scenario {scenario} --num_completions {args.num_completions}"
                        print(command)
                        os.system(command)

    else:
        for scenario in scenarios:
            for prompt in prompts: 
                for perspective in perspectives:
                    command = f"python3 forwardpass_inferences{'_within' if args.within else ''}_{args.model}.py --purpose {args.purpose} --prompt {prompt} --perspective {perspective} --output_dir {args.output_dir} --scenario {scenario} --num_completions {args.num_completions}"
                    print(command)
                    os.system(command)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--output_dir", type=str, default="gemini_test")
    parser.add_argument("--purpose", type=str, default="trust")
    parser.add_argument("--within", action="store_true")
    parser.add_argument("--num_completions", type=int, default=40)
    parser.add_argument("--model", type=str, default = "gemini")
    return parser.parse_args()

if __name__ == "__main__":
    args = parse_args()
    main(args)
