#!/bin/bash

models=("claude-3-5-sonnet-20241022" "gpt-4o" "meta-llama/Llama-3.3-70B-Instruct-Turbo")
purposes=("trust" "reward_quality" "offer_quality")
prompts=("direct" "cot")
perspectives=("first" "user")

for model in "${models[@]}"; do
    (
        echo "Starting jobs for model: $model"
        for purpose in "${purposes[@]}"; do
            for prompt in "${prompts[@]}"; do
                for perspective in "${perspectives[@]}"; do
                    python3 youtube_sponsorship_inference.py \
                        --purpose "$purpose" \
                        --prompt "$prompt" \
                        --perspective "$perspective" \
                        --model "$model"
                done
            done
        done
        echo "Finished jobs for model: $model"
    ) &  # <-- Parallelization happens here
done

wait  # Wait for all parallel processes to finish
echo "All models done."