import os
import glob
import json
import re

# Find all folders starting with youtube_inference_results
folders = glob.glob("youtube_inference_results*")

# Process each folder
for folder in folders:
    if os.path.isdir(folder):
        print(f"Processing folder: {folder}")
        
        # Get all files in the current folder
        files = [f for f in os.listdir(folder) if os.path.isfile(os.path.join(folder, f))]
        
        # Process each file
        for file in files:
            file_path = os.path.join(folder, file)
            print(f"  Processing file: {file_path}")
            
            # Read the JSON file
            with open(file_path, 'r') as f:
                data = json.load(f)
            
            # Process each entry
            for entry in data:
                if 'model_response' in entry:
                    # Get model response
                    response = entry['model_response']
                    
                    # Find the last contiguous set of characters (non-whitespace)
                    matches = re.findall(r'\S+', response)
                    last_text = matches[-1] if matches else ""
                    
                    # Extract numerical characters
                    numbers = re.findall(r'\d+', last_text)
                    
                    # Use the last number as the score if found
                    if numbers:
                        score = int(numbers[-1])
                        entry['score'] = score
                        
                        # Add flipped score based on flip flag
                        if entry.get('flipped') == True:
                            entry['flipped_score'] = 100 - score
                        else:
                            entry['flipped_score'] = score
                    else:
                        entry['score'] = None
                        entry['flipped_score'] = None
            
            # Write the updated data back to the file
            with open(file_path, 'w') as f:
                json.dump(data, f, indent=2)
