import os
import glob
import json

def process_json_file(filepath):
    """Process a JSON file and remove entries without required fields."""
    try:
        with open(filepath, 'r') as file:
            data = json.load(file)
        
        # Keep only entries that have at least one of the required fields
        if isinstance(data, list):
            filtered_data = [
                entry for entry in data 
                if "rec_vr" in entry and "val_vr" in entry and "value" in entry
            ]
        elif isinstance(data, dict):
            # If it's a dictionary, we'll filter its values if they are lists
            filtered_data = {}
            for key, value in data.items():
                if isinstance(value, list):
                    filtered_data[key] = [
                        entry for entry in value 
                        if "rec_vr" in entry or "val_vr" in entry or "value" in entry
                    ]
                else:
                    filtered_data[key] = value
        
        # Write the filtered data back to the file
        with open(filepath, 'w') as file:
            json.dump(filtered_data, file, indent=2)
        
        return True
    except Exception as e:
        print(f"Error processing {filepath}: {e}")
        return False

def main():
    # Find all folders beginning with webppl_compatible_youtube_inference_results
    base_dir = os.getcwd()  # Current directory
    folders = glob.glob(os.path.join(base_dir, "webppl_compatible_youtube_inference_results*"))
    
    for folder in folders:
        if os.path.isdir(folder):
            print(f"Processing folder: {folder}")
            # Process all JSON files in the folder
            json_files = glob.glob(os.path.join(folder, "*.json"))
            
            processed = 0
            for json_file in json_files:
                if process_json_file(json_file):
                    processed += 1
            
            print(f"Processed {processed} out of {len(json_files)} JSON files in {folder}")

if __name__ == "__main__":
    main()