import json, os
import argparse
import openai

def parse_file(filename):
    with open(filename, 'r') as file:
        trials = json.load(file)
    print(len(trials))
    for data in trials:
        for entry in data:
            messages_to_parse = entry["messages"][-1]['content']
            print(messages_to_parse)
            if "direct" in filename:
                if not messages_to_parse.isdigit():
                    print("Error!")
                    print(f"Invalid score found: {messages_to_parse}")
                    entry["score"] = input("Please enter a valid score: ")
                else:
                    entry["score"] = int(messages_to_parse)
            #elif "cot" in filename:
            else:
                last_word = messages_to_parse.split()[-1]
                score = ''.join(filter(str.isdigit, last_word))
                if not score.isdigit():
                    print("Error!")
                    print(f"Invalid score found: {messages_to_parse}")
                    entry["score"] = int(input("Please enter a valid score: "))
                else:   
                    entry["score"] = int(score)
    
    with open(filename, 'w') as file:
        json.dump(trials, file, indent=4)

def main(args):
    for filename in os.listdir(args.directory):
        print(filename)
        filepath = os.path.join(args.directory, filename)
        parse_file(filepath)

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--directory", type=str, default="deepseek-r1_test")
    return parser.parse_args()

if __name__ == "__main__":
    args = parse_args()
    main(args)
