#!/bin/bash

models=("claude-3-5-sonnet-20241022" "gpt-4o")
gamerules=("competitive" "cooperative")
prompts=("direct" "cot")

for model in "${models[@]}"; do
    (
        echo "Starting jobs for model: $model"
        for gamerule in "${gamerules[@]}"; do
            for prompt in "${prompts[@]}"; do
                python3 vigilance_game.py \
                    --gamerule "$gamerule" \
                    --prompt "$prompt" \
                    --model "$model"
            done
        done
        echo "Finished jobs for model: $model"
    ) &  # <-- Parallelization happens here
done

wait  # Wait for all parallel processes to finish
echo "All models done."