import os 

os.environ['CUDA_VISIBLE_DEVICES'] = "5" 
import torch
from tqdm import tqdm
import json
from diffusers import StableDiffusionPipeline, DPMSolverMultistepScheduler, DiffusionPipeline


# Use the Euler scheduler here instead
# scheduler = EulerDiscreteScheduler.from_pretrained(model_id, subfolder="scheduler")
# pipe = StableDiffusionPipeline.from_pretrained(model_id, scheduler=scheduler, torch_dtype=torch.float16)
# pipe = pipe.to("cuda")

def read_jsonl(path):
    results=[]
    with open(path,"r") as f:
        for line in f:
            result=json.loads(line)
            results.append(result)
    return results



class1_data=read_jsonl(class1_path)
class2_data=read_jsonl(class2_path)

pipeline = DiffusionPipeline.from_pretrained(
                model_id,
                torch_dtype=torch.float16,
                safety_checker=None
            )
pipeline.set_progress_bar_config(disable=True)

pipe = pipeline.to("cuda")

image_dir = "images"

'''
for i in tqdm(range(len(class1_data))):
    # print(f"Processing image {i}/{len(dataset['train'])}")
    prompt = class1_data[i]["text"]
    id=class1_data[i]["id"]
    # print(prompt)
    image = pipe(prompt).images[0]  
    
'''
'''
for i in tqdm(range(len(class2_data))):
    # print(f"Processing image {i}/{len(dataset['train'])}")
    prompt = class2_data[i]["text"]
    id=class2_data[i]["id"]
    # print(prompt)
    image = pipe(prompt).images[0]  
 
'''

for i in tqdm(range(len(class2_data))):
    # print(f"Processing image {i}/{len(dataset['train'])}")
    prompt = class2_data[i]["text"]
    id=class2_data[i]["id"]
    # print(prompt)
    image = pipe(prompt).images[0]  
