# MixBin -- Classification
This is a PyTorch implementation of MixBin, a framework for training binary neural networks. The code is evaluated on 2 classification datasets CIFAR100 and TinyImageNet, using the cResNet20, ResNet18 and VGG11.

For the purpose of standardization, we use the architecture defination from [OpenLTH framework](https://github.com/facebookresearch/open_lth) and fix random seed during training.

## Requirements

* Python 3.7 or greater
* torch==1.11.0
* torchvision==0.12.0
* tqdm==4.53.0
* pandas==1.3.0
* numpy==1.20.3
* scikit-learn==0.24.2

or ```pip install -r requirements.txt```

## Run Experiments

All the classification experiments can be run using ```mixbin_trainer.py```

```
List of various command line arguments with example use:

--experiment_name (str): Name of the experiment

--epochs (int): Number of epochs to train
    Use: 160 for CIFAR100 and 120 for TinyImageNet

--seed (int): Fix random seed

--model_compression (str): Compression method for the model
    Use: 'mixbin' to run MixBin with BinReLU activation else 'mixbin_{}'.format(activation) to run MixBin with other activation (identity, relu, hardtanh)

--model_name (str): Model architecture
    Use: cifar_dsresnet_20, cifar_vgg_11 or dsresnet_18

--dataset_name (str): Dataset name
    Use: cifar100 or tinyimagenet

--dataset_num_classes (int): Number of classes in the dataset
    Use: 100 for CIFAR100 and 200 for TinyImageNet

--keep_full_precision (list): Layer numbers to keep full precision
    Use: list of layer number not to be compressed. 
    Note: cifar_dsresnet_20 has 18 layers and dsresnet_18 has 16

--scheduler_milestones (list): Milestones for the scheduler
    Use: 80 120 for CIFAR100 and 60 90 for TinyImageNet

--batch_size (int): Batch size for training
    Use: 128 for CIFAR100 and 64 for TinyImageNet
```

Example: 
```bash
python mixbin_trainer.py --experiment_name="binarize_12_layer"  --epochs=160 --seed=42 \
                    --keep_full_precision 1 2 3 4 5 6 7 8 9 10 11 13 14 15 16 17 18 --batch_size=128 \
                    --scheduler_milestones 80 120 --dataset_name="cifar100" --dataset_num_classes=100 \
                    --model_name="cifar_dsresnet_20" --model_compression="mixbin"
```