from models import cifar_dsresnet, cifar_resnet, cifar_vgg, dsresnet

registered_models = [cifar_vgg.Model, cifar_resnet.Model, cifar_dsresnet.Model, dsresnet.Model]

def get_model_from_config(config):
    model_name = config.model_name
    for registered_model in registered_models:
        if registered_model.is_valid_model_name(model_name):
            return registered_model.get_model_from_config(config)
    raise ValueError(f"Model {model_name} is not registered.")