from __future__ import absolute_import
 
import os
import argparse
from got10k.experiments import *
 
from siamfc import TrackerSiamFC
 
if __name__ == '__main__':
    ap = argparse.ArgumentParser()
    ap.add_argument("--model_type", type=str)
    args = ap.parse_args()
 
    net_path = f'pretrained/siamfc_alexnet_e50_{args.model_type}.pth'
    root_dir = os.path.expanduser('~/data/GOT10K')
 
    tracker = TrackerSiamFC(net_path=net_path, model_type=args.model_type)
    tracker.name = args.model_type
 
    seqs = ExperimentGOT10k(root_dir, subset='test')
 
    seqs.run(tracker)
    seqs.report([tracker.name])
