## BIG LEARNING VARIATIONAL AUTO-ENCODERS  

[//]: # "<p align="center">"

[//]: # "  <img src="" width="480">"

[//]: # "</p>"


* On the image experiments associated with MNIST, Fashion and CelebA.

### Catalog

- [x] BigLearn-VAE   on the MNIST dataset
- [x] BigLearn-VAE   on the Fashioin dataset
- [x] BigLearn-VAE   on the CelebA dataset

### Dataset

We do experiments on MNIST, Fashion-MNIST and CelebA dataset. These datasets are downloaded from the official website.

#### MNIST

Download the data from: http://yann.lecun.com/exdb/mnist/

#### Fashion-MNIST

Download the data from: https://github.com/zalandoresearch/fashion-mnist

#### CelebA 

Download the data from: http://mmlab.ie.cuhk.edu.hk/projects/CelebA.html


###  BigLearn-VAE on the MNIST dataset:
```python
python main_MNIST_BigLearnVAE.py \
	--model UniViT \
    --data_path ${IMAGE_DIR}$ \
    --input_size 32 \
    --batch_size ${BATCH_SIZE}$ \
    --lr 2e-5 \
    --patch_size 4 \
    --z_dim 128 \
    --embed_dim 512 \
    --depth 10 \
    --betaKL 0.01 \
    --epochs 1000 
    --output_dir ${RESULTS_DIR}$ \
    --gpus ${GPU_NUMBER}$ \
```

###  BigLearn-VAE on the Fashion-MNIST dataset:

```python
python main_Fashion_BigLearnVAE.py \
	--model UniViT \
    --data_path ${IMAGE_DIR}$ \
    --input_size 32 \
    --batch_size ${BATCH_SIZE}$ \
    --lr 2e-5 \
    --patch_size 4 \
    --z_dim 128 \
    --embed_dim 512 \
    --depth 10 \
    --betaKL 0.01 \
    --epochs 1000 
    --output_dir ${RESULTS_DIR}$ \
    --gpus ${GPU_NUMBER}$ \
```

### BigLearn-VAE on the CelebA dataset:

```python
# Train Patch-AE
cd ./patch_ae
python main_CelebA_PatchAE_ViT.py \
	--model ViTPatchAE \
	--data_path ${IMAGE_DIR}$ \
	--input_size 128 \
    --batch_size 16 \
    --patch_size 16 \
    --latent_dim 512 \
    --noise_std 1 \
    --bar_weight 0.01 \
    --vit_weight 0.01 \
    --z_dim 128 \
    --embed_dim 768 \
    --depth 12 \
    --num_heads 8 \
    --mlp_ratio 4 \
    --epochs 1000 \
    --output_dir ${RESULTS_DIR} \
    --gpus 2 \
    
# Train BigLearn-VAE
python main_CelebA_BigLearnVAE.py \
	--model initPatchUniViT \
    --data_path ${IMAGE_DIR}$ \
    --batch_size 16 \
    --lr 1e-4 \
    --min_lr 2e-6 \
    --patch_size 16 \
    --num_heads 8 \
    --mlp_ratio 4 \
    --z_dim 128 \
    --embed_dim 768 \
    --depth 12 \
    --betaKL 0.001 \
    --ELastNorm LN \
    --DLastNorm LN \
    --latent_dim 512 \
    --nfilter 32 \
    --noise_std 1 \
    --epochs 1000 
    --output_dir ${RESULTS_DIR}$ \
    --gpus ${GPU_NUMBER}$ \
    --ae_path ${Patch-AE MODEL PATH}$\
```

